using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Collections;

namespace FS28BluetoothSlaveModeDemo
{
    public partial class MainWindow : Form
    {
        private FamComm m_commFam;
        private bool m_bStop;
        private byte[] m_pImage;
        private byte[] m_pWSQ;
        private byte[] m_pSample;
       /* private enum SampleTypes { ANSI = 0, ISO };
        private SampleTypes m_sampleType; */
        private string m_sampleType;
        private uint m_nSampleSize;
        private uint m_nWSQsize;
        private enum ImageTypes { RawImage = 0, WSQ };
        private ImageTypes m_ImageType;
        private bool m_bHasImage = false;
        private bool m_bExit;
        private uint m_nIDL;
        private uint m_nIDH;
        private byte m_nUserType;
        private StringBuilder m_strCommandList = new StringBuilder(30 * 64);
        private int m_nCountOfCommandLists = 0;
        private bool m_bShowImage = true;
        private byte m_nMaxSamples;
        private byte m_nStart_pos;
        private string[] m_strComPorts;
        private byte m_nSavedInterface;
        private string m_strSavedComPort;
        private UInt64[] m_pSelectedUserID = null;
        private string m_strPassword = "123456"; //default login password
        private bool m_bLogin = false;
        private bool m_bPIV = true;
        private bool m_bPrintSlefDefineMsg = false;
        /// <summary>
        /// This delegate enables asynchronous calls for setting
        /// the text property on a status control.
        /// </summary>
        /// <param name="text"></param>
        delegate void SetMessageCallback(string text);
        delegate void SetCommandTextCallback(string text);
        delegate void SetImageCallback(Bitmap hBitmap);
        delegate void SetProgressBarCallback(byte Action);  //0 - Invisible, 1 - Visible, 2 - PerformStep
        delegate void EnableControlsCallback(bool bEnable);

        public MainWindow()
        {
            InitializeComponent();
            m_bStop = false;
            m_bExit = false;
            m_pImage = new byte[153602];   //320*480+2
            progressBar1.Minimum = 0;
            progressBar1.Maximum = 3;
            progressBar1.Step = 1;
            progressBar1.Value = 0;
            m_commFam = new FamComm();
            m_commFam.Baudrate = 115200;// 921600; //For Winodws 7 Bluetooth Device Manager , the maximum baudarte is 115200
            m_commFam.OnAddCommandList += new AddCommandListHandle(this.AddCommandList);
            m_commFam.OnShowCommandList += new ShowCommandListHandle(this.ShowCommandList);
            m_commFam.OnShowTextMessage += new ShowTextMessageHandle(this.ShowTextMessage);
            m_commFam.AddCommandEventHandle();
            m_commFam.AddTextEventHandle();
            if (picboxImage.Width > 320 && picboxImage.Height > 480)
            {
                picboxImage.Width = 320;
                picboxImage.Height = 480;
                int nWidthOffset = tbCommandList.Width - 320;
                int nHeightOffset = labelCmdList.Top - picboxImage.Bottom -10;
                labelCmdList.Top -= nHeightOffset;
                tbCommandList.Width = picboxImage.Width;
                tbCommandList.Top -= nHeightOffset;
                tbCommandList.Height += nHeightOffset;
                if (nWidthOffset > 0)
                    this.Width -= nWidthOffset;
            }
        }

        private void LoadParameter()
        {
            string szFileName = Path.Combine(Directory.GetCurrentDirectory(), "setting.bin");
            try
            {
                using (FileStream fileStream = new FileStream(szFileName, FileMode.Open))
                {
                    UTF8Encoding utfEncoder = new UTF8Encoding();
                    byte[] Data = new byte[10];
                    if (fileStream.Length < 11)
                        throw new IOException(String.Format("Bad file {0}", fileStream.Name));
                    m_nSavedInterface = (byte)fileStream.ReadByte();
                    fileStream.Read(Data, 0, 10);
                    m_strSavedComPort = utfEncoder.GetString(Data, 0, Data.Length);
                    int nPwdLength = fileStream.ReadByte();
                    if (nPwdLength > 0)
                    {
                        byte[] byPwd = new byte[nPwdLength];
                        fileStream.Read(byPwd, 0, nPwdLength);
                        m_strPassword = utfEncoder.GetString(byPwd, 0, byPwd.Length);
                    }
                }
            }
            catch (Exception)
            {
            }
        }

        private void SaveParameter()
        {
            string szFileName = Path.Combine(Directory.GetCurrentDirectory(), "setting.bin");
            using (FileStream fileStream = new FileStream(szFileName, FileMode.Create))
            {
                UTF8Encoding utfEncoder = new UTF8Encoding();
                byte[] Data = null;
                Data = utfEncoder.GetBytes(m_strSavedComPort);
                byte[] Data2 = new byte[10];
                Array.Copy(Data, Data2, Data.Length);
                fileStream.WriteByte(m_nSavedInterface);
                fileStream.Write(Data2, 0, Data2.Length);
                byte[] byPwd = null;
                byPwd = utfEncoder.GetBytes(m_strPassword);
                fileStream.WriteByte((byte)byPwd.Length);
                fileStream.Write(byPwd, 0, byPwd.Length);
            }
        }

        private void MainWindow_Load(object sender, EventArgs e)
        {
            LoadParameter();
            EnableControl(false);
            comboMaxSample.SelectedIndex = 2;
            comboMsgStartLine.SelectedIndex = 0;
            comboSampleType.SelectedIndex = 0;
            FamSerialComm.EnumerateComPorts();
            int nCount = FamSerialComm.FriendlyNameComPorts.Count;
            int nSelected = 0;
            if (nCount > 0)
            {
                string[] strFriendlyNames = new string[nCount];
                m_strComPorts = new string[nCount];
                FamSerialComm.FriendlyNameComPorts.Keys.CopyTo(m_strComPorts, 0);
                FamSerialComm.FriendlyNameComPorts.Values.CopyTo(strFriendlyNames, 0);
                for (int i = 0; i < nCount; i++)
                {
                    comboComPorts.Items.Add(m_strComPorts[i] + " - " + strFriendlyNames[i]);
                    if (m_strSavedComPort != null)
                        if (m_strSavedComPort.CompareTo(m_strComPorts[i]) == 0)
                            nSelected = i;
                }
            }
            comboComPorts.SelectedIndex = nSelected;
            FormPassword formP = new FormPassword();
            formP.IsLogin = m_bLogin;
            formP.LoginPassword = m_strPassword;
            if (formP.ShowDialog() == DialogResult.Cancel)
            {
                EnableControl(false);
                btnPassword.Enabled = true;
                btnExit.Enabled = true;
            }
            else
                m_bLogin = formP.IsLogin;
            System.Threading.Thread.Sleep(100);
            this.Focus();
        }

        private void ShowImage(int BitmapWidth, int BitmapHeight, byte[] pRawImage)
        {
            MyBitmapFile myFile = new MyBitmapFile(BitmapWidth, BitmapHeight, pRawImage);
            MemoryStream BmpStream = new MemoryStream(myFile.BitmatFileData);
            Bitmap Bmp = new Bitmap(BmpStream);
            UpdateScreenImage(Bmp);
        }

        private void ShowWSQImage(uint WSQsize, byte[] pWSQImage)
        {
            FTRIMGPARMS ImgParm;
            ImgParm = new FTRIMGPARMS();
            ImgParm.WSQ_size = WSQsize;

            if (FtrWSQ.ftrWSQ_GetImageParameters(pWSQImage, ref ImgParm) == 0)
            {
                SetMessageText("Failed to call ftrWSQ_GetImageParameters");
                return;
            }

            m_pImage = new byte[ImgParm.RAW_size];
            if (FtrWSQ.ftrWSQ_ToRawImage(pWSQImage, ref ImgParm, m_pImage) == 0)
            {
                SetMessageText("Failed to call ftrWSQ_ToRawImage");
                return;
            }
            ShowImage((int)ImgParm.Width, (int)ImgParm.Height, m_pImage);
        }

        private void AddCommandList(byte nFlag, byte[] Command)
        {
            if (m_nCountOfCommandLists > 29)    //keep maximum 30 commands
                m_strCommandList.Remove(0, 46); //each line contains fixed 46 chars

            string strCmd = string.Format("{0:X2} {1:X2} {2:X2} {3:X2} {4:X2} {5:X2} {6:X2} {7:X2} {8:X2} {9:X2} {10:X2} {11:X2} {12:X2}\r\n",
                    Command[0], Command[1], Command[2], Command[3], Command[4], Command[5], Command[6],
                    Command[7], Command[8], Command[9], Command[10], Command[11], Command[12]);
            if (nFlag == 0)
                m_strCommandList.Append("Host: " + strCmd);
            else
                m_strCommandList.Append("Fam : " + strCmd);
            if (m_nCountOfCommandLists < 30)
                m_nCountOfCommandLists++;
        }

        private void ShowCommandList()
        {
            SetCommandText(m_strCommandList.ToString());
        }

        private void ShowTextMessage(string text)
        {
            SetMessageText(text);
        }

        private void ResetCommandList()
        {
            m_strCommandList.Remove(0, m_strCommandList.Length);
            SetCommandText("");
            m_nCountOfCommandLists = 0;
            SetMessageText("");
        }

        private void SetMessageText(string text)
        {
            // Do not change the state control during application closing.
            if (m_bExit)
                return;
            if (this.tbMessage.InvokeRequired)
            {
                SetMessageCallback d = new SetMessageCallback(this.SetMessageText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                tbMessage.Text = text;
                Update();
            }
        }

        private void SetCommandText(string text)
        {
            // Do not change the state control during application closing.
            if (m_bExit)
                return;
            if (this.tbCommandList.InvokeRequired)
            {
                SetCommandTextCallback d = new SetCommandTextCallback(this.SetCommandText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                tbCommandList.Text = text;
                Update();
            }
        }

        private void SetProgressbar(byte Action)
        {
            // Do not change the state control during application closing.
            if (m_bExit)
                return;
            if (this.progressBar1.InvokeRequired)
            {
                SetProgressBarCallback d = new SetProgressBarCallback(this.SetProgressbar);
                this.Invoke(d, new object[] { Action });
            }
            else
            {
                if (Action == 0)
                {
                    progressBar1.Value = 0;
                    progressBar1.Visible = false;
                }
                else if (Action == 1)
                    progressBar1.Visible = true;
                else
                    progressBar1.PerformStep();
            }
        }

        private void UpdateScreenImage(Bitmap hBitmap)
        {
            // Do not change the state control during application closing.
            if (m_bExit)
                return;
            if (this.picboxImage.InvokeRequired)
            {
                SetImageCallback d = new SetImageCallback(this.UpdateScreenImage);
                this.Invoke(d, new object[] { hBitmap });
            }
            else
            {
                picboxImage.Image = hBitmap;
            }
        }

        private void EnableControl(bool bEnable)
        {
            // Do not change the state control during application closing.
            if (m_bExit)
                return;
            if (this.InvokeRequired)
            {
                EnableControlsCallback d = new EnableControlsCallback(this.EnableControl);
                this.Invoke(d, new object[] { bEnable });
            }
            else
            {
                btFirmwareVersion.Enabled = btnGlobalSecurityLevel.Enabled = btnSyncTime.Enabled = btnReadIR.Enabled = btnReadBattery.Enabled = btnPassword.Enabled = ((FamSerialComm.m_SerialPort != null) && bEnable) ? true : false;// bEnable;
                gbUserManagement.Enabled = ((FamSerialComm.m_SerialPort != null) && bEnable) ? true : false;
                btnGetSample.Enabled = btnCapture.Enabled = btnCaptureWSQ.Enabled = btnVerify.Enabled = btnEnroll.Enabled = btnIdentify.Enabled = checkPIV.Enabled = ((FamSerialComm.m_SerialPort != null) && bEnable) ? true : false;// bEnable;
                comboMaxSample.Enabled = ((FamSerialComm.m_SerialPort != null) && bEnable) ? true : false;
                btnSave.Enabled = (m_bHasImage && bEnable) ? true : false;
                if (FamSerialComm.m_SerialPort != null) //if the port is already opened: allow it
                btnCancel.Enabled = !bEnable;
                btEnableSelfDefineMsg.Enabled = ((FamSerialComm.m_SerialPort != null) && bEnable) ? true : false;
                btClearMsg.Enabled = btSendMsg.Enabled = textBoxMsg.Enabled = comboMsgStartLine.Enabled = (m_bPrintSlefDefineMsg && bEnable) ? true : false;
            }
        }

        private void btnCapture_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            m_bStop = false;
            Thread WorkerThread = new Thread(new ThreadStart(CaptureThread));
            WorkerThread.Start();
        }

        private void btnEnroll_Click(object sender, EventArgs e)
        {
            FormEnroll formE = new FormEnroll();
            if (formE.ShowDialog() == DialogResult.OK)
            {
                UInt64 ullID = UInt64.Parse(formE.UserID);
                m_nIDL = (uint)ullID;
                m_nIDH = (uint)(ullID / 0x100000000);
                m_nIDH += (uint)(formE.GroupID << 24);
                m_nIDH += (uint)(formE.FingerID << 16);
                m_nUserType = formE.UserType;
                m_bStop = false;
                ResetCommandList();
                Thread WorkerThread = new Thread(new ThreadStart(EnrollThread));
                WorkerThread.Start();
            }
            else
                SetMessageText("Cancelled by user");
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            m_bStop = true;
            m_bExit = true;
            SaveParameter();
        }

        private void btnVerify_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            m_bStop = false;
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                 EnableControl(true);
                 return;
            }

            /*if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            // get the user id first
            if (!GetUserID(false))
            {
                EnableControl(true);
                
                return;
            }
            // start the worker thread
            Thread WorkerThread = new Thread(new ThreadStart(VerifyThread));
            WorkerThread.Start();
        }

        private void btnIdentify_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            m_bStop = false;
            Thread WorkerThread = new Thread(new ThreadStart(IdentifyThread));
            WorkerThread.Start();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            m_bStop = true;
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            SaveFileDialog dlgSave = new SaveFileDialog();
           /* dlgSave.Filter = "bmp files (*.bmp)|*.bmp";
            if (dlgSave.ShowDialog() == DialogResult.OK)
            {
                MyBitmapFile myFile = new MyBitmapFile(320, 480, m_pImage);
                FileStream file = new FileStream(dlgSave.FileName, FileMode.Create);
                file.Write(myFile.BitmatFileData, 0, myFile.BitmatFileData.Length);
                file.Close();
            } */

            //---------------------------------------
            switch (m_ImageType)
            {
                case ImageTypes.RawImage:
                    dlgSave.Filter = "bmp files (*.bmp)|*.bmp|raw files (*.raw)|*.raw";
                    break;
                case ImageTypes.WSQ:
                    dlgSave.Filter = "bmp files (*.bmp)|*.bmp|raw files (*.raw)|*.raw|wsq files (*.wsq)|*.wsq";
                    break;
                default:
                    break;
            }

            if (dlgSave.ShowDialog() == DialogResult.OK)
            {
                FileStream file = new FileStream(dlgSave.FileName, FileMode.Create);
                if (dlgSave.FilterIndex == 1)   //bitmap
                {
                    MyBitmapFile myFile;
                    myFile = new MyBitmapFile(320, 480, m_pImage);
                    file.Write(myFile.BitmatFileData, 0, myFile.BitmatFileData.Length);
                }
                else if (dlgSave.FilterIndex == 2)  //binary
                {
                    file.Write(m_pImage, 0, 153600);
                }
                else if (dlgSave.FilterIndex == 3)  //wsq
                {

                    if (m_ImageType == ImageTypes.WSQ && m_nWSQsize > 0)
                        file.Write(m_pWSQ, 0, (int)m_nWSQsize);
                }
                file.Close();
            }
        }

        private bool GetUserID(bool bWithUserType)
        {
            //bWithUserType == true -> change the user type. Group ID and Finger ID are ignored, set to 0.
            //					and all of the same user id will be changed at the same time
            // Get user's list
            uint nListLength = 0;
            byte nRet;

            nRet = m_commFam.FamGetUserListLength(ref nListLength);
            if (nRet != 0)
            {
                if (nRet == FamDefs.RET_UNKNOWN_COMMAND)	// for FS83, command getuserlist is not supported
                {
                    FormUserID formUid = new FormUserID();
                    formUid.IsUserTypeShow = bWithUserType;
                    if (formUid.ShowDialog() == DialogResult.OK)
                    {
                        m_nIDL = (uint)formUid.FullUserID;
                        m_nIDH = (uint)(formUid.FullUserID / 0x100000000);
                        if (bWithUserType)
                            m_nUserType = formUid.UserType;
                        return true;
                    }
                    else
                    {
                        SetMessageText("Cancelled by user!");
                        return false;
                    }
                }
                else
                {
                    SetMessageText(m_commFam.ErrorMessage);
                    return false;
                }
            }
            else
            {
                if (nListLength == 0)
                {
                    SetMessageText("Empty database in FAM!");
                    return false;
                }
                byte[] pUserList = m_commFam.FamUserList;
                FormUserList formList = new FormUserList();
                formList.UserList = pUserList;
                formList.IsUserTypeShow = bWithUserType;

                if (formList.ShowDialog() == DialogResult.OK)
                {
                    if (bWithUserType && !formList.IsUserTypeChanged)
                    {
                        SetMessageText("User type is not changed!");
                        pUserList = null;
                        return false;
                    }
                    else
                    {
                        m_pSelectedUserID = formList.SelectedUserIDList;
                        m_nIDL = (uint)formList.FullUserID;
                        m_nIDH = (uint)(formList.FullUserID / 0x100000000);
                        if (bWithUserType)
                            m_nUserType = formList.UserType;
                        pUserList = null;
                        return true;
                    }
                }
                else
                {
                    SetMessageText("Cancelled by user!");
                    pUserList = null;
                    return false;
                }
            }
        }

        private void btnChangeUser_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            // get the user id first
            if (!GetUserID(true))
            {
                EnableControl(true);
               // m_commFam.CloseConnection();
                return;
            }
            if (m_commFam.FamChangeUserType(m_nIDL, m_nIDH, m_nUserType) == 0)
                SetMessageText("User type is changed!");
            else
                SetMessageText(m_commFam.ErrorMessage);

            EnableControl(true);
           // m_commFam.CloseConnection();
        }

        private void btnGetUser_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            // get the user id first
            if (!GetUserID(false))
            {
                EnableControl(true);
                
                return;
            }
            FormDbFolder formDbf = new FormDbFolder();
            DialogResult dr = formDbf.ShowDialog();
            if (dr == DialogResult.OK)
            {
                SetMessageText("Downloading template...");
                byte nGroupID = 0;
                byte nFingerID = 0;
                string strFileName;
                for (int i = 0; i < m_pSelectedUserID.Length; i++)
                {
                    m_nIDL = (uint)m_pSelectedUserID[i];
                    m_nIDH = (uint)(m_pSelectedUserID[i] / 0x100000000);
                    nGroupID = (byte)(m_nIDH / 0x1000000);
                    nFingerID =(byte)(m_nIDH / 0x10000);
                    uint nTemplateLength = 0;
                    if (m_commFam.FamDownloadTemplateLength(m_nIDL, m_nIDH, ref nTemplateLength) == 0)
                    {
                        byte[] pTemplate = m_commFam.FamDownloadedTemplate;
                        strFileName = Path.Combine(Directory.GetCurrentDirectory(), formDbf.DbFolderName);
                        strFileName = string.Format("{0:s}\\{1:d}_{2:d}_{3:d}.fbn", strFileName, nGroupID, nFingerID, (m_pSelectedUserID[i] & 0x0000FFFFFFFFFFFF));
                        if (File.Exists(strFileName))
                        {
                            if (MessageBox.Show("Do you want to overwrite the template file?\n", "Template file overwrite", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.No)
                            {
                                SetMessageText("Canceled by user");
                                pTemplate = null;
                                continue;
                            }
                        }
                        FileStream file = new FileStream(strFileName, FileMode.Create);
                        file.WriteByte((byte)nTemplateLength);
                        file.WriteByte((byte)(nTemplateLength >> 8));
                        file.WriteByte((byte)(nTemplateLength >> 16));
                        file.WriteByte((byte)(nTemplateLength >> 24));
                        file.Write(pTemplate, 0, (int)nTemplateLength);
                        file.Close();
                        SetMessageText("User template is saved!");
                        pTemplate = null;
                    }
                    else
                        SetMessageText(m_commFam.ErrorMessage);
                }
            }
            else
            {
                SetMessageText("Canceled by user");
            }
            EnableControl(true);
            
        }

        private void btnSendUser_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
           /* if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            FormTemplateList formList = new FormTemplateList();
            if( formList.ShowDialog() == DialogResult.OK )
            {
                foreach (string strFileName in formList.SelectedTemplateFiles)
                {
                    FileStream file = new FileStream(strFileName, FileMode.Open, FileAccess.Read);
                    int nLength = file.ReadByte() + (file.ReadByte() << 8) + (file.ReadByte() << 16) + (file.ReadByte() << 24);
                    if (nLength > 0)
                    {
                        byte[] pTemplate = new byte[nLength + 2]; // addition bytes for checksum
                        if (nLength == file.Read(pTemplate, 0, nLength))
                        {
                            if (m_commFam.FamUploadTemplate((uint)nLength, pTemplate) == 0)
                            {
                                if (m_commFam.FamStoreTemplate(0, 0, 0x80) == 0)
                                    SetMessageText("User template is sent to FAM!");
                                else
                                    SetMessageText(m_commFam.ErrorMessage);
                            }
                            else
                                SetMessageText(m_commFam.ErrorMessage);
                        }
                        else
                            SetMessageText("Invalid template file!");
                        pTemplate = null;
                    }
                    else
                        SetMessageText("Invalid template file!");
                    file.Close();
                }
            }
            else
                SetMessageText("Cancelled by user!");

            EnableControl(true);
            
        }

        private void btnDeleteOneUser_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            // get the user id first
            if (!GetUserID(false))
            {
                EnableControl(true);
                
                return;
            }
            if (m_commFam.FamDeleteOneUser(m_nIDL, m_nIDH) == 0)
            {
                SetMessageText("User is deleted.");
            }
            else
                SetMessageText(m_commFam.ErrorMessage);

            EnableControl(true);
            
        }

        private void btnDeleteAllUser_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            if (MessageBox.Show("Are you sure to delete all the users?\n", "Delete All User", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                if (m_commFam.FamDeleteAllUser() == 0)
                    SetMessageText("All the users are deleted.");
                else
                    SetMessageText(m_commFam.ErrorMessage);
            }
            else
                SetMessageText("Cancelled by user!");

            EnableControl(true);
            
        }

        private void btFirmwareVersion_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            string strVerFw = "";
            string strVerHw = "";
            string strFS28VerFw = "";
            string strFS28VerHw = "";
            if (m_commFam.FamGetVersion(ref strVerFw, ref strVerHw) == 0)
            {
                
                if (m_commFam.FamGetFS28Version(ref strFS28VerFw, ref strFS28VerHw) == 0)
                {
                    string strVersion = "Current FAM F/W Version: " + strVerFw + ", FAM H/W Version: " + strVerHw + "\nCurrent AVR F/W Version: " + strFS28VerFw + ", FS28 H/W Version: " + strFS28VerHw;
                    MessageBox.Show(strVersion, "FAM firmware version", MessageBoxButtons.OKCancel);
                }
                else
                {
                    SetMessageText(m_commFam.ErrorMessage);
                }
            }
            else
            {
                SetMessageText(m_commFam.ErrorMessage);
            }
            EnableControl(true);
            
        }

        private bool DownloadFirmwareData(bool bRamFlash, int nLength, ref byte[] RxBuf)
        {
            if (nLength <= 0)
                return false;

            uint nRxLength = 0;
            uint nAddress = 0;
            uint nTotal = (uint)nLength;
            int nRetries = 0;
            byte[] RxTemp = new byte[1030];
            string strPerMsg;
            byte nRet = 0;

            while (nTotal > 0)
            {
                nRxLength = 1024;
                if (nRxLength > nTotal)
                    nRxLength = nTotal;
                if (bRamFlash)
                    nRet = m_commFam.FamDownloadFromRam(nAddress, nRxLength, RxTemp);
                else
                    nRet = m_commFam.FamDownloadFromFlash(nAddress, nRxLength, RxTemp);
                if( nRet != 0)
                {
                    nRetries++;
                    if (nRetries > 2)
                    {
                        SetMessageText(m_commFam.ErrorMessage);
                        return false;
                    }
                    Thread.Sleep(20);
                    continue;
                }
                nRetries = 0;
                Array.Copy(RxTemp, 0, RxBuf, nAddress, nRxLength);
                nTotal -= nRxLength;
                nAddress += nRxLength;
                if( bRamFlash )
                    strPerMsg = string.Format("Downloading from RAM......{0:d}%", (nAddress * 100) / nLength);
                else
                    strPerMsg = string.Format("Downloading from Flash......{0:d}%", (nAddress * 100) / nLength);
                SetMessageText(strPerMsg);
            }
            return true;
        }

        private bool UpgradeIt(string csPath)
        {
            FileStream file = new FileStream(csPath, FileMode.Open, FileAccess.Read);
            int nLength = (int)file.Length;
            if ((nLength <= 0) || (nLength > 0x40000))
            {
                SetMessageText(string.Format("ERROR: file length = {0:d}", nLength));
                return false;
            }
            byte[] TxBuf = new byte[nLength + 12];
            byte[] RxBuf = new byte[nLength + 12];
            int i = 0;
            if (nLength != file.Read(TxBuf, 0, nLength))
            {
                SetMessageText(string.Format("ERROR: file read length is not {0:d}", nLength));
                return false;
            }
            file.Close();
            
            //try to download from RAM
            if (m_commFam.FamDownloadFromRam(0, 10, RxBuf) == 0)
            {
                SetMessageText("Uploading to RAM ......");
                if (m_commFam.FamUploadToRam(0, (uint)nLength, TxBuf) == 0)
                {
                    //if (m_commFam.FamDownloadFromRam(0, (uint)nLength, RxBuf) == 0)
                    if (!DownloadFirmwareData(true, nLength, ref RxBuf))
                    {
                        TxBuf = null;
                        RxBuf = null;
                        return false;
                    }
                    for (i = 0; i < nLength; i++)
                    {
                        if (RxBuf[i] != TxBuf[i])
                        {
                            SetMessageText(string.Format("{0:d} != {1:d}, Error upload/download - RAM", RxBuf[i], TxBuf[i]));
                            TxBuf = null;
                            RxBuf = null;
                            return false;
                        }
                    }
                }
                else
                {
                    SetMessageText(m_commFam.ErrorMessage);
                    TxBuf = null;
                    RxBuf = null;
                    return false;
                }
                SetMessageText(string.Format("Write to RAM {0:d} bytes.", nLength));
                Thread.Sleep(200);
                SetMessageText("Writing to Flash......");
                //---- write to flash ---------------------------------
                if (m_commFam.FamWriteToFlash((uint)nLength) != 0)
                {
                    SetMessageText(m_commFam.ErrorMessage);
                    TxBuf = null;
                    RxBuf = null;
                    return false;
                }
                SetMessageText(string.Format("Write to Flash {0:d} bytes.", nLength));
                Thread.Sleep(200);
                //-----	Verify---------------------------------------------
                if (!DownloadFirmwareData(false, nLength, ref RxBuf))
                {
                    TxBuf = null;
                    RxBuf = null;
                    return false;
                }
                // Compare
                SetMessageText("Verifying ......");
                for (i = 0; i < nLength; i++)
                {
                    if (RxBuf[i] != TxBuf[i])
                    {
                        SetMessageText(string.Format("Compare error: addr=0x{0:X}, mustbe=0x{1:X}, really=0x{2:X}", i, TxBuf[i], RxBuf[i]));
                        TxBuf = null;
                        RxBuf = null;
                        return false;
                    }
                }
                SetMessageText("Reboot, please wait ......");
                m_commFam.FamReboot();
                SetMessageText("Upgrade FAM Firmware successfully!");
            }
            else// old algoritm
            {
                SetMessageText("Old algorithm not supported!");
                TxBuf = null;
                RxBuf = null;
                return false;
            }
            TxBuf = null;
            RxBuf = null;
            return true;
        }

        private void btnGlobalSecurityLevel_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            uint nPages = 0;
            if (m_commFam.FamGetSpace(ref nPages) != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                
                return;
            }
            // get global security level
            byte nGSL = 0;
            if (m_commFam.FamGetSecurityLevel(ref nGSL) != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                
                return;
            }

            FormOthers formO = new FormOthers();
            formO.FreePages = nPages;
            formO.GlobalSecurityLevel = nGSL;

            if (formO.ShowDialog() == DialogResult.OK)
            {
                if (formO.IsGSLChanged)
                {
                    nGSL = formO.GlobalSecurityLevel;
                    if (m_commFam.FamSetSecurityLevel(nGSL) == 0)
                        SetMessageText("Global security level is changed!");
                    else
                        SetMessageText(m_commFam.ErrorMessage);
                }
                else
                    SetMessageText("Global security level is not changed!");
            }
            else
                SetMessageText("Cancelled by user!");
            EnableControl(true);
            
        }

        private void checkShowImage_CheckedChanged(object sender, EventArgs e)
        {
            m_bShowImage = checkShowImage.Checked;
            if (!m_bShowImage)
            {
                picboxImage.Image = null;
                m_bHasImage = false;
                btnSave.Enabled = false;
            }
        }

        private void comboMaxSample_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nMaxSamples = (byte)(comboMaxSample.SelectedIndex + 1);
            progressBar1.Maximum = m_nMaxSamples;
        }

        private void comboComPorts_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_strSavedComPort = m_strComPorts[comboComPorts.SelectedIndex];
            m_commFam.ComPort = m_strComPorts[comboComPorts.SelectedIndex];
        }

        private void btnSyncTime_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            DateTime dtNow = System.DateTime.Now;
            byte nSec = (byte)BinToDec((byte)dtNow.Second);
            byte nMin = (byte)BinToDec((byte)dtNow.Minute);
            byte nHour = (byte)BinToDec((byte)dtNow.Hour);
            byte nDay = (byte)BinToDec((byte)dtNow.Day);
            byte nMonth = (byte)BinToDec((byte)dtNow.Month);
            int nYear = dtNow.Year;
            if (nYear < 2000 || nYear>2099)
            {
                SetMessageText("Year is not correct!");
                EnableControl(true);
                
                return;
            }
            nYear -= 2000;
            nYear = BinToDec((byte)nYear);
            if ((m_commFam.FamSyncTime(nYear, nMonth, nDay, nHour, nMin, nSec)) != 0)
                SetMessageText(m_commFam.ErrorMessage);
            else
            {
                if (m_commFam.FS28RefreshTime() != 0)
                   SetMessageText(m_commFam.ErrorMessage); 
                else
                SetMessageText("Date time is synchronized.");
            }
            EnableControl(true);
            
        }

        private int BinToDec(byte nSrc)
        {
            if (nSrc < 10)
                return nSrc;
            int nDes = 0;
            string strSrc = String.Format("{0:d}", nSrc);
            int nLen = strSrc.Length;
            for (int i = 0; i < nLen; i++)
            {
                int ntemp = int.Parse(strSrc.Substring(i, 1));
                for (int j = i; j < nLen - 1; j++)
                    ntemp = ntemp * 0x10;
                nDes += ntemp;
            }
            return nDes;
        }

        private void btnUserLog_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            FormUserLog frmLog = new FormUserLog();
            frmLog.m_commFam = m_commFam;
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            frmLog.ShowDialog();

            SetMessageText("");
            EnableControl(true);
                        
        }

        private void checkWithLog_CheckedChanged(object sender, EventArgs e)
        {
            m_commFam.MatchWithLog = checkWithLog.Checked;
        }

        private void btnReadIR_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            byte nIR = 0;
            if ((m_commFam.FamGetIR(ref nIR)) != 0)
                SetMessageText(m_commFam.ErrorMessage);
            else
            {
                string strMsg = String.Format("Read IR successfully. IR={0:d}", nIR);
                SetMessageText(strMsg);
            }
            EnableControl(true);
        }

        private void btnPassword_Click(object sender, EventArgs e)
        {
            FormPassword formP = new FormPassword();
            formP.IsLogin = m_bLogin;
            formP.LoginPassword = m_strPassword;
            if (formP.ShowDialog() == DialogResult.OK)
            {
                if (!m_bLogin)
                {
                    m_bLogin = formP.IsLogin;
                    if (m_bLogin)
                        EnableControl(true);
                }
                else
                {
                    m_strPassword = formP.LoginPassword;
                    SaveParameter();
                    SetMessageText("Password is changed.");
                }
            }
        }

        private void checkPIV_CheckedChanged(object sender, EventArgs e)
        {
            m_bPIV = checkPIV.Checked;
        }

        private void BtnOpenPort_Click(object sender, EventArgs e)
        {
            //if the port is already opened: close it
            if (FamSerialComm.m_SerialPort != null)
            {
                m_commFam.CloseConnection();
                BtnOpenPort.Text  = "&Open Port";
                m_bPrintSlefDefineMsg = false;
                btEnableSelfDefineMsg.Text = "Enable Self Define Msg";
                EnableControl(false); 
            }
            else
            {
                ResetCommandList();
                if (m_commFam.PrepareConnection() != 0)
                    SetMessageText(m_commFam.ErrorMessage);
                else
                {
                    BtnOpenPort.Text = "&Close Port";
                    EnableControl(true);
                }
            }
        }

        private void btEnableSelfDefineMsg_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            m_bPrintSlefDefineMsg = !m_bPrintSlefDefineMsg;
            if (m_bPrintSlefDefineMsg)
                btEnableSelfDefineMsg.Text = "Disable Self Define Msg";
            else
                btEnableSelfDefineMsg.Text = "Enable Self Define Msg";
            if (m_commFam.FS28EnableSelfMsg(m_bPrintSlefDefineMsg) != 0)
                    SetMessageText(m_commFam.ErrorMessage);
 
            EnableControl(true);
        }

        private void btSendMsg_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }

            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }

                string Msg = textBoxMsg.Text;
                uint msg_len = (uint)Msg.Length;
                /*There are in total 4 lines can be printed on FS28 LCD message section. Each line can contains maximum 21 characters.
                 *For FS28 AVR v5.2.04 or below, the maximum row is 4, so the maximum char can be printed is 4*21 = 84 
                 *For FS28 AVR v5.2.05 or above, the maximum row is 12, so the maximum char can be printed is 12*21 = 252 
                 */
                uint MaxChar = (uint) m_nStart_pos;
                MaxChar = MaxChar * 21 + msg_len; 
                if (Msg.Length <= 0)
                {
                    EnableControl(true);
                    return;
                }
                else if (MaxChar > 252) // 12 rows * 21 char
                {
                    EnableControl(true);
                    SetMessageText("Exceed the message limited!");
                    return;
                }
                
                char[] cMsg = Msg.ToCharArray(0, Msg.Length);
                byte[] pMsg = new byte[msg_len + 1];//+1 is for checksum.
                for(int i=0; i < Msg.Length; i++)
                {
                    pMsg[i] = (byte) cMsg[i];
                }
                
                if (m_commFam.FS28SendMsg(msg_len, m_nStart_pos, pMsg) != 0) 
                SetMessageText(m_commFam.ErrorMessage);

            EnableControl(true);
        }

        private void comboMsgStartLine_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_nStart_pos = (byte)(comboMsgStartLine.SelectedIndex);
        }

        private void btClearMsg_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            textBoxMsg.Text = "";
            if (m_commFam.FS28ClearMsg() != 0) 
                SetMessageText(m_commFam.ErrorMessage);

            EnableControl(true);
        }

        private void btnReadBattery_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            EnableControl(false);
            if (FamSerialComm.m_SerialPort == null)
            {
                EnableControl(true);
                return;
            }
            /*
            if (m_commFam.CheckConnection() != 0)
            {
                SetMessageText(m_commFam.ErrorMessage);
                EnableControl(true);
                return;
            }*/
            uint nBatteryVol = 0;
            if ((m_commFam.FS28ReadBattery(ref nBatteryVol)) != 0)
                SetMessageText(m_commFam.ErrorMessage);
            else
            {
                string strMsg = String.Format("Read battery successfully.Voltage ={0:d}mV", nBatteryVol);
                SetMessageText(strMsg);
            }
            EnableControl(true);
        }

        private void btnCaptureWSQ_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            m_bStop = false;
            Thread WorkerThread = new Thread(new ThreadStart(CaptureWSQThread));
            WorkerThread.Start();
        }

        private void btnGetSample_Click(object sender, EventArgs e)
        {
            ResetCommandList();
            m_bStop = false;
            Thread WorkerThread = new Thread(new ThreadStart(GetSampleThread));
            WorkerThread.Start();
        }

        private void comboSampleType_SelectedIndexChanged(object sender, EventArgs e)
        {
            int temp;
            temp =  comboSampleType.SelectedIndex;
            if (temp == 0)
                m_sampleType = "ANSI"; 
            else if(temp == 1)
                m_sampleType = "ISO";
        }


    }
}